/***************************************************************************
 *   Copyright (C) 2008 by Manuel Schrape                                  *
 *   manuel.schrape@gmx.de                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License.        *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifndef MKTOOL_H
#define MKTOOL_H

#include <QMainWindow>
#include <QSettings>
#include <QString>
#include <QTimer>
#include <QComboBox>
#include <QIcon>
#include <QProcess>

#include <qwt_plot_curve.h>
#include <qwt_plot_grid.h>
#include <qwt_legend.h>
#include <qwt_plot.h>
#include <qwt_compass.h>
#include <qwt_compass_rose.h>
#include <qwt_dial_needle.h>

#include "ui_mktool.h"
#include "wdg_Settings.h"
#include "dlg_LCD.h"
#include "dlg_Map.h"
#include "dlg_MotorMixer.h"

#include "../Classes/cConnection.h"
#include "../Classes/cSettings.h"
#include "../Classes/cKML_Server.h"
#include "../Classes/cQMK_Server.h"
#include "../Classes/cAttitude.h"
#include "../Classes/cSpeedMeter.h"
#include "../Logger/Logger.h"
#include "../typedefs.h"

class QextSerialPort;

class MKTool : public QMainWindow, public Ui::dlg_mktool_UI
{
      Q_OBJECT

public:
      MKTool();
      ~MKTool();

private:
    // Object für Kopter-Verbindung
    cConnection *o_Connection;

    // Settings-Object (Programmeinstellungen)
    cSettings *Settings;

    // Settings-Widget (FC-Settings)
    wdg_Settings *f_Settings;

    // HTTP-Server-Object für KML-Files
    cKML_Server *KML_Server;

    // QMK-Serverobjekt
    cQMK_Server *QMK_Server;

    // LCD-Dialog
    dlg_LCD *f_LCD;

    // MotorMixer-Dialog
    dlg_MotorMixer *f_MotorMixer;

    // Map-Dialog
    dlg_Map *f_Map;

    //TCP-Socket
    QTcpSocket *TcpSocket;

    // Default-Ticker
    QTimer *Ticker;

    // Kopie der Tabs des Hauptfensters
    QWidget *TabWidgets[7];

    // Analogwert-Beschreibungen
    QLabel *lb_Analog[MaxAnalog];

    // Analogwerte
    int AnalogData[MaxAnalog];

    // Plots für die Analogwerte
    QwtPlotCurve *Plot[MaxAnalog];    

    // Datenspeicher für die Plots
    double aData[MaxAnalog][MaxPlot];
    double aID[MaxPlot];
    int NextPlot;

    AttitudeIndicator *Attitude;
    cSpeedMeter * SpeedMeter;

    // Ticker-Event-Array
    bool TickerEvent[MaxTickerEvents];
    bool TickerDiv;

    // Aktuelle und Max-Anzahl der LCD-Seiten
    int LCD_Page;
    int LCD_MAX_Page;

    //Logger für CVS und andere
    Logger * logger;

    sMode Mode;
    sRxData RxData;
    sNaviData Navi;
    sMotor Motor;

    QString RXS;
    QString LastSend;

    // Softwareupdate
    QProcess *Update;

    // Sendedatenbuffer
    char TX_Data[150];

    // FC-Settings
    int FCSettings[MaxParameter];

    // Programm Initialisieren
    void init_GUI();
    void init_Objects();
    void init_Connections();
    void init_Arrays();
    void init_Plot();
    void init_Cockpit();

    // Daten-Plotter
    void update_Plot();
    void config_Plot();

    void new_NaviData(sRxData RX);
    void parse_TargetKML();

    // Debugdaten anzeigen und speichern.
    void show_DebugData();
    void update_Log();

    // Programmeinstellungen speichern
    void set_Preferences();

private slots:
    void slot_QMKS_Connect();
    void slot_QMKS_Connected();
    void slot_QMKS_Disconnected(int Error);

    void slot_set_Settings(cSettings *t_Settings);

    void slot_MAP_SetTarget(sWayPoint Target);
    void slot_MAP_SetWayPoints(QList<sWayPoint> l_WayPoints);


    void slot_showTerminal(int Typ, QString Text);

    void slot_ac_Hardware();
    void slot_rb_Hardware();

    void slot_ac_StartServer();

    void slot_Test();

    void slot_ac_Config();
    void slot_ac_Preferences();
    void slot_ac_StartPlotter();
    void slot_ac_View();
    void slot_ac_FastDebug();
    void slot_ac_NoDebug();
    void slot_ac_FastNavi();
    void slot_ac_NoNavi();
    void slot_ac_About();
    void slot_ac_GetLabels();
    void slot_ac_Motortest();
    void slot_ac_LCD();
    void slot_ac_Map();
    void slot_ac_MotorMixer();

    void slot_pb_HexFile();
    void slot_pb_SendTarget();

    // Default-Ticker
    void slot_Ticker();

    // LCD-Seite vor / zurück
    void slot_LCD_UP();
    void slot_LCD_DOWN();

    void slot_Motortest(sMotor p_Motor);

    // Firmeware-Update
    void slot_pb_Update();
    void slot_UpdateShell();

    // Seriell-Port Slots
    void slot_newData(sRxData RX);
    void slot_OpenPort();

    void slot_TabChanged(int Tab);

    void slot_RecordLog();

    void slot_ScrollPlot(int Pos);

    // FC-Settings lesen / Schreiben
    void slot_GetFCSettings();
    void slot_SetFCSettings();
};

#endif
